package gov.va.med.mhv.common.api.enumeration;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public enum CountryEnum {
	UNITED_STATES 					("USA", "United States"),
	AFGHANISTAN 					("AFG", "Afghanistan"),
	ALBANIA 						("ALB", "Albania"),
	ALGERIA 						("DZA", "Algeria"),
	ANDORRA 						("AND", "Andorra"),
	ANGOLA 							("AGO", "Angola"),
	ANGUILLA 						("AIA", "Anguilla"),
	ANTARCTICA 						("ATA", "Antarctica"),
	ANTIGUA_AND_BARBUDA 			("ATG", "Antigua and Barbuda"),
	ARGENTINA 						("ARG", "Argentina"),
	ARMENIA 						("ARM", "Armenia"),
	ARUBA 							("ABW", "Aruba"),
	AUSTRALIA 						("AUS", "Australia"),
	AUSTRIA 						("AUT", "Austria"),
	AZERBAIJAN 						("AZE", "Azerbaijan"),
	BAHAMAS 						("BHS", "Bahamas"),
	BAHRAIN 						("BHR", "Bahrain"),
	BANGLADESH 						("BGD", "Bangladesh"),
	BARBADOS 						("BRB", "Barbados"),
	BELARUS 						("BLR", "Belarus"),
	BELGIUM 						("BEL", "Belgium"),
	BELIZE 							("BLZ", "Belize"),
	BENIN 							("BEN", "Benin"),
	BERMUDA 						("BMU", "Bermuda"),
	BHUTAN 							("BTN", "Bhutan"),
	BOLIVIA 						("BOL", "Bolivia"),
	BONAIRE							("BES", "Bonaire"),
	BOSNIA_AND_HERZEGOVINA 			("BIH", "Bosnia and Herzegovina"),
	BOTSWANA 						("BWA", "Botswana"),
	BOUVET_ISLAND 					("BVT", "Bouvet Island"),
	BRAZIL 							("BRA", "Brazil"),
	BRITISH_INDIAN_OCEAN_TERRITORY 	("IOT", "British Indian Ocean Territory"),
	BRUNEI_DARUSSALAM 				("BRN", "Brunei Darussalam"),
	BULGARIA 						("BGR", "Bulgaria"),
	BURKINA_FASO 					("BFA", "Burkina Faso"),
	BURUNDI 						("BDI", "Burundi"),
	CAMBODIA 						("KHM", "Cambodia"),
	CAMEROON 						("CMR", "Cameroon"),
	CANADA 							("CAN", "Canada"),
	CAPE_VERDE 						("CPV", "Cape Verde"),
	CAYMAN_ISLANDS 					("CYM", "Cayman Islands"),
	CENTRAL_AFRICAN_REPUBLIC 		("CAF", "Central African Republic"),
	CHAD 							("TCD", "Chad"),
	CHILE 							("CHL", "Chile"),
	CHINA 							("CHN", "China"),
	CHRISTMAS_ISLAND 				("CXR", "Christmas Island"),
	COCOS_KEELING_ISLANDS 			("CCK", "Cocos (Keeling) Islands"),
	COLOMBIA 						("COL", "Colombia"),
	COMOROS 						("COM", "Comoros"),
	CONGO_BRAZZAVILLE 				("COG", "Congo (Brazzaville)"),
	CONGO_KINSHASA 					("COD", "Congo (Kinshasa)"),
	COOK_ISLANDS 					("COK", "Cook Islands"),
	COSTA_RICA 						("CRI", "Costa Rica"),
	CÔTE_D_IVOIRE 					("CIV", "Côte d'Ivoire"),
	CROATIA 						("HRV", "Croatia"),
	CUBA 							("CUB", "Cuba"),
	CURACAO							("CUW", "CuraÃ§ao"), //new
	CYPRUS 							("CYP", "Cyprus"),
	CZECH_REPUBLIC 					("CZE", "Czech Republic"),
	DENMARK 						("DNK", "Denmark"),
	DJIBOUTI 						("DJI", "Djibouti"),
	DOMINICA 						("DMA", "Dominica"),
	DOMINICAN_REPUBLIC 				("DOM", "Dominican Republic"),
	ECUADOR 						("ECU", "Ecuador"),
	EGYPT 							("EGY", "Egypt"),
	EL_SALVADOR 					("SLV", "El Salvador"),
	EQUATORIAL_GUINEA 				("GNQ", "Equatorial Guinea"),
	ERITREA 						("ERI", "Eritrea"),
	ESTONIA 						("EST", "Estonia"),
	ETHIOPIA 						("ETH", "Ethiopia"),
	FALKLAND_ISLANDS 				("FLK", "Falkland Islands"),
	FAROE_ISLANDS 					("FRO", "Faroe Islands"),
	FIJI 							("FJI", "Fiji"),
	FINLAND 						("FIN", "Finland"),
	FRANCE 							("FRA", "France"),
	FRENCH_GUIANA 					("GUF", "French Guiana"),
	FRENCH_POLYNESIA 				("PYF", "French Polynesia"),
	FRENCH_SOUTHERN_TERRITORIES 	("ATF", "French Southern Territories"),
	GABON 							("GAB", "Gabon"),
	GAMBIA 							("GMB", "Gambia"),
	GEORGIA 						("GEO", "Georgia"),
	GERMANY 						("DEU", "Germany"),
	GHANA 							("GHA", "Ghana"),
	GIBRALTAR 						("GIB", "Gibraltar"),
	GREECE 							("GRC", "Greece"),
	GREENLAND 						("GRL", "Greenland"),
	GRENADA 						("GRD", "Grenada"),
	GUADELOUPE 						("GLP", "Guadeloupe"),
	GUATEMALA 						("GTM", "Guatemala"),
	GUAM							("GUM", "Guam"), //new
	GUERNSEY						("GGY", "Guernsey"), //new
	GUINEA 							("GIN", "Guinea"),
	GUINEA_BISSAU 					("GNB", "Guinea-Bissau"),
	GUYANA 							("GUY", "Guyana"),
	HAITI 							("HTI", "Haiti"),
	HEARD_AND_MCDONALD_ISLANDS 		("HMD", "Heard and McDonald Islands"),
	HONDURAS 						("HND", "Honduras"),
	HONG_KONG 						("HKG", "Hong Kong"),
	HUNGARY 						("HUN", "Hungary"),
	ICELAND 						("ISL", "Iceland"),
	INDIA 							("IND", "India"),
	INDONESIA 						("IDN", "Indonesia"),
	IRAN 							("IRN", "Iran"),
	IRAQ 							("IRQ", "Iraq"),
	IRELAND 						("IRL", "Ireland"),
	ISLE_OF_MAN						("IMN", "Isle of Man"), //new
	ISRAEL 							("ISR", "Israel"),
	ITALY 							("ITA", "Italy"),
	JAMAICA 						("JAM", "Jamaica"),
	JAPAN 							("JPN", "Japan"),
	JERSEY							("JEY", "Jersey"), //new
	JORDAN 							("JOR", "Jordan"),
	KAZAKHSTAN 						("KAZ", "Kazakhstan"),
	KENYA 							("KEN", "Kenya"),
	KIRIBATI 						("KIR", "Kiribati"),
	KOREA_NORTH 					("PRK", "Korea (North)"),
	KOREA_SOUTH 					("KOR", "Korea (South)"),
	KUWAIT 							("KWT", "Kuwait"),
	KYRGYZSTAN 						("KGZ", "Kyrgyzstan"),
	LAOS 							("LAO", "Laos"),
	LATVIA 							("LVA", "Latvia"),
	LEBANON 						("LBN", "Lebanon"),
	LESOTHO 						("LSO", "Lesotho"),
	LIBERIA 						("LBR", "Liberia"),
	LIBYA 							("LBY", "Libya"),
	LIECHTENSTEIN 					("LIE", "Liechtenstein"),
	LITHUANIA 						("LTU", "Lithuania"),
	LUXEMBOURG 						("LUX", "Luxembourg"),
	MACAO 							("MAC", "Macao"),
	MACEDONIA 						("MKD", "Macedonia"),
	MADAGASCAR 						("MDG", "Madagascar"),
	MALAWI 							("MWI", "Malawi"),
	MALAYSIA 						("MYS", "Malaysia"),
	MALDIVES 						("MDV", "Maldives"),
	MALI 							("MLI", "Mali"),
	MALTA 							("MLT", "Malta"),
	MARSHALL_ISLAND					("MHL", "Marshall Islands "), //new
	MARTINIQUE 						("MTQ", "Martinique"),
	MAURITANIA 						("MRT", "Mauritania"),
	MAURITIUS 						("MUS", "Mauritius"),
	MAYOTTE 						("MYT", "Mayotte"),
	MEXICO 							("MEX", "Mexico"),
	MICRONESIA 						("FSM", "Micronesia"),
	MOLDOVA 						("MDA", "Moldova"),
	MONACO 							("MCO", "Monaco"),
	MONGOLIA 						("MNG", "Mongolia"),
	MONTSERRAT 						("MSR", "Montserrat"),
	MOROCCO 						("MAR", "Morocco"),
	MOZAMBIQUE 						("MOZ", "Mozambique"),
	MYANMAR 						("MMR", "Myanmar"),
	NAMIBIA 						("NAM", "Namibia"),
	NAURU 							("NRU", "Nauru"),
	NEPAL 							("NPL", "Nepal"),
	NETHERLANDS 					("NLD", "Netherlands"),
//	NETHERLANDS_ANTILLES 			("", "Netherlands Antilles"), -- dissolved in 2010
	NEW_CALEDONIA 					("NCL", "New Caledonia"),
	NEW_ZEALAND 					("NZL", "New Zealand"),
	NICARAGUA 						("NIC", "Nicaragua"),
	NIGER 							("NER", "Niger"),
	NIGERIA 						("NGA", "Nigeria"),
	NIUE 							("NIU", "Niue"),
	NORFOLK_ISLAND 					("NFK", "Norfolk Island"),
	NORTHERN_MARIANA_ISLAND			("MNP", "Northern Mariana Islands "), //new
	NORWAY 							("NOR", "Norway"),
	OMAN 							("OMN", "Oman"),
	PAKISTAN 						("PAK", "Pakistan"),
	PALAU							("PLW", "Palau"), //new
	PALESTINE						("PSE", "Palestine"), //new
	PANAMA 							("PAN", "Panama"),
	PAPUA_NEW_GUINEA 				("PNG", "Papua New Guinea"),
	PARAGUAY 						("PRY", "Paraguay"),
	PERU 							("PER", "Peru"),
	PHILIPPINES 					("PHL", "Philippines"),
	PITCAIRN 						("PCN", "Pitcairn"),
	POLAND 							("POL", "Poland"),
	PORTUGAL 						("PRT", "Portugal"),
	QATAR 							("QAT", "Qatar"),
	REUNION 						("REU", "Reunion"),
	ROMANIA 						("ROU", "Romania"),
	RUSSIAN_FEDERATION 				("RUS", "Russian Federation"),
	RWANDA 							("RWA", "Rwanda"),
	SAINT_BARTHELEMY				("BLM" , "Saint Barthelemy"), //new  
	SAINT_HELENA 					("SHN", "Saint Helena"),
	SAINT_KITTS_AND_NEVIS 			("KNA", "Saint Kitts and Nevis"),
	SAINT_LUCIA 					("LCA", "Saint Lucia"),
	SAINT_MARTIN					("MAF", "Saint Martin"), //new 
	SAINT_PIERRE_AND_MIQUELON 		("SPM", "Saint Pierre and Miquelon"),
	SAINT_VINCENT_AND_THE_GRENADINES("VCT", "Saint Vincent and the Grenadines"),
	SAMOA							("WSM", "Samoa"), //new
	SAN_MARINO 						("SMR", "San Marino"),
	SAO_TOME_AND_PRINCIPE 			("STP", "Sao Tome and Principe"),
	SAUDI_ARABIA 					("SAU", "Saudi Arabia"),
	SENEGAL 						("SEN", "Senegal"),
	SERBIA_AND_MONTENEGRO 			("SRB", "Serbia and Montenegro"),
	SEYCHELLES 						("SYC", "Seychelles"),
	SIERRA_LEONE 					("SLE", "Sierra Leone"),
	SINGAPORE 						("SGP", "Singapore"),
	SINT_MAARTEN					("SXM", "Sint Maarten"), //new 
	SLOVAKIA 						("SVK", "Slovakia"),
	SLOVENIA 						("SVN", "Slovenia"),
	SOLOMON_ISLANDS 				("SLB", "Solomon Islands"),
	SOMALIA 						("SOM", "Somalia"),
	SOUTH_AFRICA 					("ZAF", "South Africa"),
	SOUTH_GEORGIA_AND_SOUTH_SANDWICH_ISLANDS ("SGS", "South Georgia and South Sandwich Islands"),
	SOUTH_SUDAN						("SSD", "South Sudan"),  //new
	SPAIN 							("ESP", "Spain"),
	SRI_LANKA 						("LKA", "Sri Lanka"),
	SUDAN 							("SDN", "Sudan"),
	SURINAME 						("SUR", "Suriname"),
	SVALBARD_JAN_MAYEN				("SJM", "Svalbard and Jan Mayen"), //new
	SWAZILAND 						("SWZ", "Swaziland"),
	SWEDEN 							("SWE", "Sweden"),
	SWITZERLAND 					("CHE", "Switzerland"),
	SYRIAN_ARAB_REPUBLIC 			("SYR", "Syrian Arab Republic"),
	TAIWAN 							("TWN", "Taiwan"),
	TAJIKISTAN 						("TJK", "Tajikistan"),
	TANZANIA 						("TZA", "Tanzania"),
	THAILAND 						("THA", "Thailand"),
	TIMOR_LESTE 					("TLS", "Timor-Leste"),
	TOGO 							("TGO", "Togo"),
	TOKELAU 						("TKL", "Tokelau"),
	TONGA 							("TON", "Tonga"),
	TRINIDAD_AND_TOBAGO 			("TTO", "Trinidad and Tobago"),
	TUNISIA 						("TUN", "Tunisia"),
	TURKEY 							("TUR", "Turkey"),
	TURKMENISTAN 					("TKM", "Turkmenistan"),
	TURKS_AND_CAICOS_ISLANDS 		("TCA", "Turks and Caicos Islands"),
	TUVALU 							("TUV", "Tuvalu"),
	UGANDA 							("UGA", "Uganda"),
	UKRAINE 						("UKR", "Ukraine"),
	UNITED_ARAB_EMIRATES 			("ARE", "United Arab Emirates"),
	UNITED_KINGDOM 					("GBR", "United Kingdom"),
	US_MINOR_OUTLYING_ISLANDS		("UMI", "United States Minor Outlying Islands"), //new 
	URUGUAY 						("URY", "Uruguay"),
	UZBEKISTAN 						("UZB", "Uzbekistan"),
	VANUATU 						("VUT", "Vanuatu"),
	VATICAN_CITY 					("VAT", "Vatican City"),
	VENEZUELA 						("VEN", "Venezuela"),
	VIET_NAM 						("VNM", "Viet Nam"),
	VIRGIN_ISLANDS_BRITISH 			("VGB", "Virgin Islands (British)"),
	VIRGIN_ISLANDS_US	 			("VGB", "US Virgin Islands"), //new
	WALLIS_AND_FUTUNA_ISLANDS 		("WLF", "Wallis and Futuna Islands"),
	WESTERN_SAHARA 					("ESH", "Western Sahara"),
	YEMEN 							("YEM", "Yemen"),
	ZAMBIA 							("ZMB", "Zambia"),
	ZIMBABWE 						("ZWE", "Zimbabwe"),
	ALAND_ISLAND					("ALA", "Aland Islands"), //new
	UNKNOWN							("UNKNOWN", "UNKNOWN")
	;  
	

	private CountryEnum() {
		
	}
	private CountryEnum(String countryCode, String countryDetailName) {
		this.countryCode = countryCode;
		this.countryDetailName = countryDetailName;
	}
	

	public static List<CountryEnum> toList(){
		return Arrays.asList(CountryEnum.values());
	}	
	
	private String countryCode;
	private String countryDetailName;
	private static final Map<String, CountryEnum> COUNTRY_BY_CODE = new HashMap<String, CountryEnum>();
	public static final Map<String, String> COUNTRY_BY_DETAIL = new TreeMap<String, String>();
	
	/* static initializer */
	static {
		for (CountryEnum countryEn : values()) {
			COUNTRY_BY_CODE.put(countryEn.getCountryCode(), countryEn);
			COUNTRY_BY_DETAIL.put(countryEn.getCountryCode() , countryEn.getCountryDetailName());
			
		}
	}

	public static CountryEnum valueOfAbbreviation(final String stateCode) {
		final CountryEnum countryEn = COUNTRY_BY_CODE.get(stateCode);
		if (countryEn != null) {
			return countryEn;
		} else {
			return UNKNOWN;
		}
	}
	
	public String getCountryCode() {
		return countryCode;
	}

	public void setCountryCode(String countryCode) {
		this.countryCode = countryCode;
	}

	public String getCountryDetailName() {
		return countryDetailName;
	}

	public void setCountryDetailName(String countryDetailName) {
		this.countryDetailName = countryDetailName;
	}
	
}
